#ifndef CHANGER_C
#define CHANGER_C

#define ADD_CHNG 1
#define RM_CHNG 2

/* Adds a random instruction */
void add_rand_inst(llist *code_list, 
                   struct main_header head,
                   llist_node *last_code){
    struct instruction new_inst;
    new_inst.dst = random() % head.var_num;
    new_inst.instruction = rand_instruction();
    char is_constant = random() % 2;
    if (is_constant){
        new_inst.src = random();
        new_inst.instruction |= 0b10000000; // Add's the constant marker
    }
    else{
        new_inst.src = random() % head.var_num;
    }

    int code_length = code_block_length(last_code->element);

    int code_pos = random() % (code_length + 1 );
    if (code_pos > code_length ){
        code_pos = code_length;
    }

    struct instruction *old_block = last_code->element;

    struct instruction *new_block = malloc((code_length + 2) *
                                          sizeof(struct instruction));

    if (new_block == NULL){
        fprintf(stderr, "Memory error\n");
        perror("malloc");
        exit(8);
    }

    last_code->element = new_block;
    
    int i;
    for (i = 0; i < code_pos; i++){
        new_block[i] = old_block[i];
    }
    new_block[i] = new_inst;
    i++;
    for (; old_block[i - 1].instruction != EOF_BLOCK; i++){
        new_block[i] = old_block[i - i];
    }
    new_block[i].instruction = EOF_BLOCK;

    free(old_block);
}

/* Removes a random instruction */
void rm_rand_inst(llist *code_list, 
                   struct main_header head,
                   llist_node *last_code){
    struct instruction new_inst;
    new_inst.dst = random() % head.var_num;
    new_inst.instruction = rand_instruction();
    char is_constant = random() % 2;
    if (is_constant){
        new_inst.src = random();
        new_inst.instruction |= 0b10000000; // Add's the constant marker
    }
    else{
        new_inst.src = random() % head.var_num;
    }

    int code_length = code_block_length(last_code->element);

    int code_pos = random() % (code_length - 1 );
    if (code_pos >= code_length ){
        code_pos = 0;
    }

    struct instruction *old_block = last_code->element;
    
    struct instruction *new_block = malloc((code_length + 1) *
                                          sizeof(struct instruction));
    
    last_code->element = new_block;

    int i;
    for (i = 0; i < code_pos; i++){
        new_block[i] = old_block[i];
    }
    for (; old_block[i + 1].instruction != EOF_BLOCK; i++){
        new_block[i] = old_block[i + 1];
    }
    new_block[i].instruction = EOF_BLOCK;

    free(old_block);

}

// Have to split moar !!!!
void change_code(FILE *fin,
                 FILE* fout,
                 int chngNum,
                 uint8 chng_type){

    if (chng_type == (ADD_CHNG | RM_CHNG)){
        if (random() % 2){
            chng_type = ADD_CHNG;
        }
        else{
            chng_type = RM_CHNG;
        }
    }

    struct main_header head;
    fread(&head, sizeof(struct main_header), 1, fin);
    llist *code_list = read_code(fin, head.block_num);
    uint8 *varlist = malloc(sizeof(uint8) * head.var_num);
    if (varlist == NULL){
        perror("malloc");
        exit(3);
    }

    llist_node* last_code,* node = code_list->first;
    last_code = node;
    while(node != NULL){
        last_code = node;
        node = node->next;
    }
    if (chng_type & ADD_CHNG){

        add_rand_inst(code_list, head, last_code);
    }
    if (chng_type & RM_CHNG){
        rm_rand_inst(code_list, head, last_code);
    }

    dump_code(fout, code_list, head);
    free(varlist);
    free_code(code_list);
}

#endif
