#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
struct stat arch_info;
int
freq (char *f, int x[256])
{
  int fd, bindex;
  unsigned char byte;
  if ((fd = open (f, O_RDONLY)) < 0)
    {
      printf ("Error opening file\n");
      exit (EXIT_FAILURE);
    }
  stat (f, &arch_info);
  while (read (fd, &byte, sizeof (unsigned char)) > 0)
    {
      bindex = (int) byte;
      x[bindex] = x[bindex] + 1;
    }
  return 0;
}

float
entropy (int f[256])
{
  float x[256];
  float entropy = 0.0;
  int i;
  memset (&x, 0x0, sizeof (x));
  for (i = 0; i < 256; i++)
    {
      x[i] = (float) f[i] / arch_info.st_size;
#ifdef DEBUG
      printf ("Prob(%x) = %f (%d times)\n", i, x[i], f[i]);
#endif
      if (x[i] > 0.0)
	entropy -= x[i] * log ((double) x[i]) / log ((double) 2.0);
    }
  return entropy;
}

float
calc_entropy (char *f)
{
  int frq[256];
  memset (&frq, 0, sizeof (frq));
  freq (f, frq);
  return entropy (frq);
}

int
main (int argc, char **argv)
{
  char *f;
  if (argc < 2)
    {
      fprintf (stderr,
	       "Necesitas un archivo para calcular entropia en el argumento\n");

      exit (EXIT_FAILURE);
    }
  f = argv[1];
  printf ("%.2f\n", calc_entropy (f));
  return 0;
}
