#!/usr/bin/env bash
# Evolve a file pointing to maximum entropy

#Float cond taken from 
# http://www.linuxjournal.com/content/floating-point-math-bash
function float_cond(){ 
    local cond=0
    if [[ $# -gt 0 ]]; then
        cond=$(echo "$*" | bc -q 2>/dev/null)
        if [[ -z "$cond" ]]; then cond=0; fi
        if [[ "$cond" != 0  &&  "$cond" != 1 ]]; then cond=0; fi
    fi
    local stat=$((cond == 0))
    return $stat
}



base="entropy.evo"
mod="entropy.evo.mod"
entropy=0
file=$base
out="out"
show=show

function read_entropy(){
    ../instructo -e -f $file < sample > $out
    entropy=`./entropy $out`
}

read_entropy
base_entropy=$entropy
echo $entropy

file=$mod
i=0
limit=8.00 # Valor objetivo
while float_cond "$entropy < $limit ";do
#    valgrind --leak-check=full -v 
    ../instructo -c -a -f "$base" -o "$mod"
    if [ $? -ne 0 ];then
        exit 1
    fi
    read_entropy
    if float_cond "$entropy >= $base_entropy";then
        echo $entropy
        base_entropy=$entropy
        mv $mod $base
        mv $out $show
    fi
    i=$(($i+1))
done
echo "Generaciones: $i"
