#ifndef FILE_INFO_C
#define FILE_INFO_C

void show_block_info(FILE *f, int block_count){
    int block_size;
    fread(&block_size, sizeof(int), 1, f);
    printf("El bloque número %i tiene %i bytes de longitud\n", 
            block_count, block_size);

    int i = 0;
    while (i < block_size){
        struct instruction inst;
        
        fread(&inst, sizeof(struct instruction), 1, f);
        switch(inst.instruction & 0b01111111){
            case ADD_INSTRUCTION:
                printf("ADD ");
                break;
            case SUB_INSTRUCTION:
                printf("SUB ");
                break;
            case SWAP_INSTRUCTION:
                printf("SWAP ");
                break;

        }
        constant_op(inst)?printf("%i const %i\n", inst.dst, inst.src):
                          printf("%i %i\n", inst.dst, inst.src);
        i += sizeof(struct instruction);
    }
}

void show_file_info(FILE *f){
    struct main_header head;
    if (fread(&head, sizeof(struct main_header), 1, f) == 1){
        printf("Número de bucles: %i\n", head.reps);
        printf("Bytes leídos al principio: %i\n", head.init_read);
        printf("Bytes escritos al final: %i\n", head.end_write);
        printf("Número de variables: %i\n", head.var_num);
        printf("Número de bloques: %i\n", head.block_num);
        int curr_block = 0;
        while ((!feof(f))&& (curr_block < head.block_num)){
            curr_block++;
            int block_pos;
            fread(&block_pos, sizeof(int), 1, f);

            int next_block = ftell(f);

            fseek(f, next_block, SEEK_SET);
            show_block_info(f, curr_block);
            fseek(f, next_block, SEEK_SET);
        }
    }
    else{
        fprintf(stderr, "Archivo incorrecto\n");
    }
}

#endif
