#ifndef ICODE_C
#define ICODE_C

#include "llist.c"

/* Variable Swapping */
#define swap(a,b) int swapper__ = a;a=b;b=swapper__;

// Have to set to unbuffered !!

/* Get's the block number */
int get_block_number(llist *code_list){
    llist_node *node = code_list->first;
    int i = 0;
    while (node != NULL){
        i++;
        node=node->next;
    }
    return i;
}

/* Get's code block length */
int code_block_length(struct instruction *i_block){
    int i;
    for (i = 0; i_block[i].instruction != EOF_BLOCK; i++);
    return i;
}

/* Dump's code blocks to a file */
void dump_code(FILE *f, llist *code_list, struct main_header head){
    fwrite(&head, sizeof(struct main_header), 1, f); // Adds the header
    int i = 0;
    int next_head_pos = ftell(f);
    int next_block_pos = sizeof(struct main_header) + (head.block_num * sizeof(int));
    llist_node *node = code_list->first;
    while (i < head.block_num){
        fwrite(&next_block_pos, sizeof(int), 1, f); // Writes next block position
        next_head_pos = ftell(f);
        fseek(f, SEEK_SET, next_block_pos);
        if (node == NULL){
            fprintf(stderr, "Odd memory error\n");
            exit(5);
        }
        int block_length = (code_block_length(node->element)) * sizeof(struct instruction);
        fwrite(&block_length, sizeof(int), 1, f ); // Writes block length
        fwrite(node->element, sizeof(struct instruction), block_length / 3, f);

        node = node->next;
        i++;
    }
}

/* Free's the code list */
void free_code(llist *code_list){
    if (code_list == NULL){
        return;
    }
    llist_node* node = code_list->first;
    while (node != NULL){
        if (node->element == NULL){
            getchar();
        }
        free(node->element);
        llist_node *past = node;
        node = node->next;
        free(past);
    }
    free(code_list);
}

/* Read's a code block */
struct instruction *get_code_block(FILE *f ){
    int block_size;
    fread(&block_size, sizeof(int), 1, f);

    if (block_size % 3 != 0){
        fprintf(stderr, "Invalid code\n");
        exit(4);
    }

    struct instruction *code;
    code = malloc((sizeof(uint8) * block_size) + (sizeof(struct instruction)));
    fread(code, 1, block_size, f);
    // Marks end of code
    code[(block_size / sizeof(struct instruction)) + 1].instruction = EOF_BLOCK;
    return code;
}

/* Reads the code blocks */
llist *read_code(FILE *f, int block_num){
    llist *code_list = new_llist();
    int i = 0;
    while ((!feof(f))&& (i < block_num)){
        i++;
        int block_pos;
        fread(&block_pos, sizeof(int), 1, f);

        int next_block = ftell(f);

        fseek(f, block_pos, SEEK_SET);

        struct instruction *code_block = get_code_block(f );
        add_to_llist(code_list, code_block);
        fseek(f, next_block, SEEK_SET);
    }
    return code_list;
}

/* Read's variables from stdin */
void read_vars(uint8 *varlist, int to_read, FILE *f){
    int i;
    for (i = 0; i < to_read; i++){
        varlist[i] = fgetc(f);
    }
}

/* Writes variables to stdout */
void write_vars(uint8 *varlist, int to_write, FILE *f, int varLen){
    int i;
    for (i = 0; i < to_write; i++){
        fputc(varlist[i % varLen], f);
    }
}

/* Runs a block of code */
void run_code_block(uint8* varlist,struct instruction* codeblock, int varLen){
    int i;
    for (i = 0; codeblock[i].instruction != EOF_BLOCK; i++){
        switch(codeblock[i].instruction){

            /* Adicion */
            case ADD_INSTRUCTION:
                if (constant_op(codeblock[i])){
                    varlist[codeblock[i].dst % varLen] += codeblock[i].src;
                }
                else{
                    varlist[codeblock[i].dst % varLen] += \
                                    varlist[codeblock[i].src % varLen];
                }
                break;

            /* Substraction */
            case SUB_INSTRUCTION:
                if (constant_op(codeblock[i])){
                    varlist[codeblock[i].dst % varLen] -= codeblock[i].src;
                }
                else{
                    varlist[codeblock[i].dst % varLen] -= \
                                    varlist[codeblock[i].src % varLen];
                }
                break;

            /* Swapping/asignation */
            case SWAP_INSTRUCTION:
                #ifdef ALLOW_ASIGN
                    if (constant_op(codeblock[i])){
                        varlist[codeblock[i].dst % varLen] = codeblock[i].src;
                    }
                    else{
                        swap(varlist[codeblock[i].dst % varLen],
                                        varlist[codeblock[i].src % varLen]);
                    }
                #else
                    ;
                    swap(varlist[codeblock[i].dst % varLen],
                                    varlist[codeblock[i].src % varLen]);

                #endif
                break;
        }
    }
}

/* Loads and runs the bytecode */
void run_code(FILE *f){
    struct main_header head;
    fread(&head, sizeof(struct main_header), 1, f);
    llist *code_list = read_code(f, head.block_num);
    uint8 *varlist = malloc(sizeof(uint8) * head.var_num);
    if (varlist == NULL){
        perror("malloc");
        exit(3);
    }
    int loop_num = 0;
    llist_node *node;
    while (loop_num < head.reps ){
        read_vars(varlist, head.init_read, stdin);
        node = code_list->first;
        while (node != NULL){
            run_code_block(varlist, node->element, head.var_num);
            node = node->next;
        }
        write_vars(varlist, head.end_write, stdout, head.var_num);
        loop_num++;
    }
    // Free pointers
    free(varlist); // Variable list
    // Code blocks
    free_code(code_list);
}

#endif
