#ifndef IFILE_C
#define IFILE_C

// Genera un bloque vacío
void write_void_block(FILE *f){
    int void_block_length = 0;
    fwrite(&void_block_length, sizeof(int), 1, f);
}

// Genera un nuevo archivo de código
void generate_void_code(FILE *f,
        int loop_num,
        int read_first,
        int write_last,
        int variables){

    struct main_header head;

    if (read_first > variables){
        fprintf(stderr, "Se necesitan al menos tantas variables como bytes a leer\n");
        return;
    }

    head.reps = loop_num;
    head.init_read = read_first;
    head.end_write = write_last;
    head.var_num = variables;
    head.block_num = 1; // Just one block
    fwrite(&head, sizeof(struct main_header), 1, f); // Adds the header

    int f_block = ftell(f) + sizeof(int);  // First block address
    fwrite(&f_block, sizeof(int), 1, f);   // Add's the first block address
    write_void_block(f);
}

#endif
