#ifndef INSTRUCTION_SET_H
#define INSTRUCTION_SET_H

/*
 *  Instructions (space = 7 bits (1 bit for variable/constant operator))
 *  - Add
 *  - Sub
 *  - Swap - asign (swap with a constant)
 *  - Nop ?
 *  
 */

struct instruction{
    uint8 instruction;
    uint8 src; /* Or constant if case */
    uint8 dst; 
};

#define EOF_BLOCK 0        /* End of block (not really code :P) */
#define ADD_INSTRUCTION 1  /* Adition */ 
#define SUB_INSTRUCTION 2  /* Substractiom */
#define SWAP_INSTRUCTION 3 /* Swap variables (asignation with constant) */ 
#define MAX_INSTRUCTION 3  /* For module operations */

/*  Si opera sobre una constante */
#define constant_op(a) (a.instruction & 0b10000000 )

#define rand_instruction() ((random() % MAX_INSTRUCTION) + 1)

#endif
