#ifndef INSTRUCTO_C
#define INSTRUCTO_C

#include "instructo.h"
char operation = NO_OP;  // Operación seleccionada
uint8 read_first = -1;  // -----------------------
uint8 write_last = -1; // Si se modifican estos parámetros
int loop_num = -1;  // tomarán un valor distinto a -1
uint8 variables = -1;//
int chng_num = 1;
char chng_type = ADD_CHNG | RM_CHNG;

char *file = NULL;
char *file_out = NULL;
int r_seed;

void show_help(char *arg0){
    printf("%s -i -f <file>: shows info from a file\n", arg0);
    printf("%s -e -f <file>: runs a file\n", arg0);
    printf("%s -n -f <file> -v <variable number> -rf <number of bytes> -wl <number of bytes> -l <number of loops>: creates a new file with the specified parameters\n", arg0);
    printf("%s -c -f <file> [-s <seed>] -o <output file> [-a|-r] [-n <change number>]: makes random changes to file\n", arg0);
}

int main(int argc, char** argv){
    int i;
    #ifdef WIN32_
        r_seed = time(NULL);
    #else
        FILE *frand = fopen("/dev/urandom", "r");
        fread(&r_seed, sizeof(int), 1, frand);
        fclose(frand);
    #endif

    for (i = 1; i < argc; i++){
        if ((strcmp(argv[i], "--new") == 0) ||
            (strcmp(argv[i], "-n") == 0)){

            operation = NEW_CODE;
        }
        else if ((strcmp(argv[i], "--info") == 0) ||
            (strcmp(argv[i], "-i") == 0)){

            operation = GET_INFO;
        }
        else if ((strcmp(argv[i], "--execute") == 0) ||
            (strcmp(argv[i], "-e") == 0)){

            operation = EXECUTE;
        }
        else if ((strcmp(argv[i], "--change") == 0) ||
            (strcmp(argv[i], "-c") == 0)){

            operation = CHANGE;
        }
        else if ((strcmp(argv[i], "--add") == 0) ||
            (strcmp(argv[i], "-a") == 0)){

            chng_type = ADD_CHNG;
        }
        else if ((strcmp(argv[i], "--remove") == 0) ||
            (strcmp(argv[i], "-r") == 0)){

            chng_type = RM_CHNG;
        }
        else if((strcmp(argv[i], "--seed") == 0) ||
            (strcmp(argv[i], "-s") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            r_seed = atoi(argv[i]);
        }
        else if((strcmp(argv[i], "--file") == 0) ||
            (strcmp(argv[i], "-f") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            file = argv[i];
        }
        else if((strcmp(argv[i], "--output") == 0) ||
            (strcmp(argv[i], "-o") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            file_out = argv[i];
        }
        else if((strcmp(argv[i], "--read-first") == 0) ||
            (strcmp(argv[i], "-rf") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            read_first = atoi(argv[i]);
        }
        else if((strcmp(argv[i], "--variables") == 0) ||
            (strcmp(argv[i], "-v") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            variables = atoi(argv[i]);
        }
        else if((strcmp(argv[i], "--write-last") == 0) ||
            (strcmp(argv[i], "-wl") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            write_last = atoi(argv[i]);
        }
        else if((strcmp(argv[i], "--loops") == 0) ||
            (strcmp(argv[i], "-l") == 0)){

            i++;
            if (i >= argc){
                fprintf(stderr, "No se ha especificado el parámetro\n");
                exit(1);
            }
            loop_num = atoi(argv[i]);
        }
        else if ((strcmp(argv[i], "--help") == 0) ||
            (strcmp(argv[i], "-h") == 0)){

            show_help(argv[0]);
            exit(0);
        }
        else{
            fprintf(stderr, "Operación desconocida\n");
            show_help(argv[0]);
            exit(0);
        }
    }
    FILE *f;
    srand(r_seed);
    switch(operation){

        // Se genera un trozo de código nuevo (hay que empezar usando esto)
        case NEW_CODE: 
            f = fopen(file, "wb");
            if (f == NULL){
                fprintf(stderr, "Error al abrir el archivo %s\n", file);
                exit(2);
            }
            generate_void_code(f, 
                loop_num, read_first, write_last, variables);
            fclose(f);
            break;

        // Se obtiene información del código (pensado para debuggear esto)
        case GET_INFO: 
            f = fopen(file, "rb");
            if (f == NULL){
                fprintf(stderr, "Error al abrir el archivo %s\n", file);
                exit(2);
            }
            show_file_info(f);
            fclose(f);
            break;
        // Ejecuta el código
        case EXECUTE:
            f = fopen(file, "rb");
            if (f == NULL){
                fprintf(stderr, "Error al abrir el archivo %s\n", file);
                exit(2);
            }
            run_code(f);
            fclose(f);
            break;

        // Cambia el código
        case CHANGE:
            f = fopen(file, "rb");
            if (f == NULL){
                fprintf(stderr, "Error al abrir el archivo %s\n", file);
                exit(2);
            }
            FILE *fout = fopen(file_out, "wb");
            if (fout == NULL){
                fprintf(stderr, "Error al abrir el archivo %s\n", file);
                fclose(f);
                exit(2);
            }
            change_code(f, fout, chng_num, chng_type);

            fclose(fout);
            fclose(f);
            break;

        default:
            fprintf(stderr, "Operación no definida\n");
            show_help(argv[0]);
    }
    return 0;
}

#endif
