// Linked-list implementation
// Written by Kenkeiras

#ifndef LLIST_C
#define LLIST_C
#include <stdlib.h>

typedef struct{
    void *element;
    void *next;
}llist_node;

typedef struct{
    llist_node *first;
    llist_node *last;
}llist;

llist *new_llist(){
    llist *l;
    l=malloc(sizeof(llist));
    l->first=NULL;
    l->last=NULL;
    return l;
}

void add_to_llist(llist *list,void *element){
    llist_node *node;
    node=malloc(sizeof(llist_node));
    node->element=element;
    node->next=NULL;
    if ((list->first==NULL)||((list->last==NULL))){
        list->first=node;
        list->last=node;
    }
    else{
        (list->last)->next=node;
        list->last=node;
    }
}

void *llist_element(llist *list,int num){
    int i;
    llist_node *node=list->first;
    for (i=0;(i<num)&&(node!=NULL);i++){
        node=node->next;
    }
    return node->element;
}

int rm_llist_element(llist *list,int num){
    int i,e=0;
    llist_node *node,*node2 = NULL;
    node = list->first;
    for (i = 0;(i < num)&&(node != NULL);i++){
        node2 = node;
        node = node->next;
    }
    if (node != NULL){
        if (list->first != node){
            node2->next=node->next;
            free(node);
            e++;
        }
        else{
            list->first=node->next;
            free(node);
            e++;
        }
    }
    return e;
}

int llist_size(llist *list){
  int size=0;
  llist_node *node=list->first;
  while (node!=NULL){
    node=node->next;
    size++;
  }
  return size;
}

// Free string list memory :)
void freestrlist(llist *list){
    llist_node *back,*nod=list->first;
    while (nod!=NULL){
        char *str;
        str=nod->element;
        free(str);
        back=nod;
        nod=nod->next;
        free(back);
    }
    list->first=NULL;
    list->last=NULL;
}


#endif
